/************************************************************************
 * @file: AudioBackendDefault.h
 *
 * @version: 0.1
 *
 * @description: This header contains definition and implementation for
 * class BackendDefault. BackendDefault class is inherited from Backend
 * Interface class. If proper Backend Name is not provided for Factory
 * class, BackendDefault class will be selected.
 *
 * @authors: Jens Lorenz, jlorenz@de.adit-jv.com 2015
 *           Thouseef Ahamed, tahamed@de.adit-jv.com 2015
 *           Vijay Palaniswamy, vijay.palaniswamy@in.bosch.com 2015
 *
 * @copyright (c) 2015 Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/

#ifndef _ADIT_UTILITY_BACKENDDEFAULT_H_
#define _ADIT_UTILITY_BACKENDDEFAULT_H_

#include "AudioBackend.h"
#include "AudioTypes.h"

namespace adit
{

namespace utility
{

namespace audio
{

class BackendDefault : public Backend
{
public:
    BackendDefault(void) {};
    virtual ~BackendDefault(void) {};

    const char* getBackendName(void) { return "Default"; };
    void setThreadSched(int policy, int priority) { (void)policy; (void)priority; };

    AudioError openStream(const std::string &in, const std::string &out,
            const AudioFormat format, const uint32_t rate, const uint32_t channels, uint32_t& frames)
    {
        (void)in; (void)out;
        (void)format; (void)rate; (void)channels; (void)frames;
        return AudioError::FAILURE;
    };
    AudioError closeStream(void) { return AudioError::FAILURE; };

    AudioError startStream(void) { return AudioError::FAILURE; };
    AudioError stopStream(void)  { return AudioError::FAILURE; };
    AudioError abortStream(void) { return AudioError::FAILURE; };

    uint64_t getStreamTimeInFrames(void) { return 0; };
    uint64_t getStreamLatencyInFrames(void) { return 0; };

    AudioError setFadeTime(const enum FadeMode mode, const enum StreamDirection direction, const uint32_t time)
    {
        (void)mode; (void)direction; (void)time;
        return AudioError::FAILURE;
    };

    AudioError getFadeTime(const enum FadeMode mode, const enum StreamDirection direction, uint32_t& time)
    {
        (void)mode; (void)direction; (void)time;
        return AudioError::FAILURE;
    };

    void setInitialTimeout(const uint32_t timeout)
    {
        (void)timeout;
    }

    uint32_t getInitialTimeout() const
    {
        return 0;
    }

};

} /* namespace audio */

} /* namespace utility */

} /* namespace adit */

#endif /* _ADIT_UTILITY_BACKENDDEFAULT_H_ */
